What is dynamic programming?

Dynamic programming is a technique used in computer science and mathematics to solve complex problems by breaking them down into simpler overlapping subproblems.
It is especially useful for optimization problems and is commonly applied to problems in fields like algorithms, economics, and artificial intelligence.
The key idea behind dynamic programming is to store the results of subproblems in a table (usually an array or a matrix) to avoid redundant calculations. 
When a subproblem's solution is needed, it can be retrieved from the table rather than recomputing it. This approach significantly improves the efficiency of algorithms for problems that exhibit optimal substructure and overlapping subproblems.


There are two main approaches to dynamic programming:

1) Top-down approach (memoization):
In this approach, you start with the original problem and break it down into smaller subproblems.
You solve each subproblem recursively and store the results in a data structure (usually a dictionary or an array) so that you can reuse them when needed. 
This approach is often implemented using recursion.

2) Bottom-up approach (tabulation):
In this approach, you start by solving the smallest subproblems first and use their solutions to build up to the original problem. 
You typically use an array or a matrix to store the solutions to subproblems, starting from the simplest and gradually solving more complex ones.
